//+------------------------------------------------------------------+
//| PChannel_m.mq4                                                   |
//+------------------------------------------------------------------+

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 DodgerBlue
#property indicator_color2 DodgerBlue
#property indicator_color3 DodgerBlue

extern int Range=6;
extern int TimeFrame=1440;

double UpBuffer[];
double DnBuffer[];
double MdBuffer[];

int i;  //
string PeriodName;  //  

int init()
{
string short_name;

SetIndexStyle(0,DRAW_LINE,1,2);
SetIndexBuffer(0,UpBuffer);
SetIndexLabel(0,"Up Channel ("+Range+")");
SetIndexDrawBegin(0,0);

SetIndexStyle(1,DRAW_LINE,1,2);
SetIndexBuffer(1,DnBuffer);
SetIndexLabel(1,"Down Channel ("+Range+")");
SetIndexDrawBegin(1,0);

SetIndexStyle(2,DRAW_LINE,2);
SetIndexBuffer(2,MdBuffer);
SetIndexLabel(2,"Middle Channel");
SetIndexDrawBegin(2,0);

IndicatorShortName(short_name);

switch(TimeFrame) //   TimeFrame      
  {
  case 1    : TimeFrame=PERIOD_M1;  break; //   ,     
  case 5    : TimeFrame=PERIOD_M5;  break;
  case 15   : TimeFrame=PERIOD_M15; break;
  case 30   : TimeFrame=PERIOD_M30; break;
  case 60   : TimeFrame=PERIOD_H1;  break;
  case 240  : TimeFrame=PERIOD_H4;  break;
  case 1440 : TimeFrame=PERIOD_D1;  break;
  case 10080: TimeFrame=PERIOD_W1;  break;
  case 43200: TimeFrame=PERIOD_MN1; break;
  default   : TimeFrame=Period();   break;
  }

switch(TimeFrame) //   
  {
  case PERIOD_M1    : PeriodName="M1";  break;
  case PERIOD_M5    : PeriodName="M5";  break;
  case PERIOD_M15   : PeriodName="M15"; break;
  case PERIOD_M30   : PeriodName="M30"; break;
  case PERIOD_H1    : PeriodName="H1";  break;
  case PERIOD_H4    : PeriodName="H4";  break;
  case PERIOD_D1    : PeriodName="D1";  break;
  case PERIOD_W1    : PeriodName="W1";  break;
  case PERIOD_MN1   : PeriodName="MN1"; break;
  }
short_name="PriceChannel("+PeriodName+","+Range+")";
return(0);
}

int start()
{
int i,counted_bars=IndicatorCounted();
//---- initial zero
   if(counted_bars<1)
      for(i=1;i<Bars;i++)
      {
         DnBuffer[i]=0.0;
         UpBuffer[i]=0.0;
         MdBuffer[i]=0.0;      
      }
//----
datetime TimeArray[];
double LowArray[],HighArray[];
int y=0;  //   

if (TimeFrame<Period()) //      
  {
  SetIndexDrawBegin(0,Bars);  //  
  SetIndexDrawBegin(1,Bars);
  SetIndexDrawBegin(2,Bars);
  Alert("Smaller timeframe chart is necessary");
  return(0);
  }
//       
ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame);
//  Low  
ArrayCopySeries(LowArray,MODE_LOW,Symbol(),TimeFrame);
// High
ArrayCopySeries(HighArray,MODE_HIGH,Symbol(),TimeFrame);

for(i=0,y=0;i<Bars-counted_bars;i++)
  {
  //           , 
  //        (   )
  if (Time[i]<TimeArray[y]) y++;
  //|   /    ,
  DnBuffer[i]=LowArray[Lowest(NULL,TimeFrame,MODE_LOW,Range,y)];
  //|        
  UpBuffer[i]=HighArray[Highest(NULL,TimeFrame,MODE_HIGH,Range,y)];
  //|LowArray  HighArray
  MdBuffer[i]=(UpBuffer[i]+DnBuffer[i])/2;
  }
Comment("PriceChannel on timeframe ", PeriodName, " with the period ", Range);
return(0);
}

//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   Comment("");
//----
   return(0);
  }

